/*
 * Decompiled with CFR 0.152.
 */
package testtool;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import res.Config;
import res.WebService;

public class KontaktDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JLabel lbl_kundennummer;
    private JTextField edt_firma;
    private JButton btn_abbrechen;
    private JButton btn_senden;
    private JLabel lbl_email;
    private JLabel lbl_vorname;
    private JLabel lbl_name;
    private JLabel lbl_firma;
    private JTextField edt_email;
    private JTextField edt_vorname;
    private JTextField edt_name;
    private JTextField edt_kundennummer;
    private Config CONFIG;
    private JFrame owner;
    private String statustext;

    public KontaktDialog(JFrame frame, Config CONFIG, String statustext) {
        super(frame);
        this.CONFIG = CONFIG;
        this.owner = frame;
        this.statustext = statustext;
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setBounds(new Rectangle(180, 150, 340, 260));
            this.setResizable(false);
            this.setTitle("Daten an Support senden");
            this.getContentPane().setLayout(null);
            this.lbl_kundennummer = new JLabel();
            this.getContentPane().add(this.lbl_kundennummer);
            this.lbl_kundennummer.setText("Kundennummer");
            this.lbl_kundennummer.setBounds(12, 12, 100, 14);
            this.edt_kundennummer = new JTextField();
            this.getContentPane().add(this.edt_kundennummer);
            this.edt_kundennummer.setBounds(135, 12, 185, 21);
            this.edt_kundennummer.setSize(180, 21);
            this.lbl_firma = new JLabel();
            this.getContentPane().add(this.lbl_firma);
            this.lbl_firma.setText("Firma");
            this.lbl_firma.setBounds(12, 45, 100, 14);
            this.edt_firma = new JTextField();
            this.getContentPane().add(this.edt_firma);
            this.edt_firma.setBounds(135, 45, 180, 21);
            this.lbl_name = new JLabel();
            this.getContentPane().add(this.lbl_name);
            this.lbl_name.setText("Name");
            this.lbl_name.setBounds(12, 78, 100, 14);
            this.edt_name = new JTextField();
            this.getContentPane().add(this.edt_name);
            this.edt_name.setBounds(135, 78, 180, 21);
            this.lbl_vorname = new JLabel();
            this.getContentPane().add(this.lbl_vorname);
            this.lbl_vorname.setText("Vorname");
            this.lbl_vorname.setBounds(12, 111, 100, 14);
            this.edt_vorname = new JTextField();
            this.getContentPane().add(this.edt_vorname);
            this.edt_vorname.setBounds(135, 111, 180, 21);
            this.lbl_email = new JLabel();
            this.getContentPane().add(this.lbl_email);
            this.lbl_email.setText("E-Mail");
            this.lbl_email.setBounds(12, 144, 100, 14);
            this.edt_email = new JTextField();
            this.getContentPane().add(this.edt_email);
            this.edt_email.setBounds(135, 144, 180, 21);
            if (this.CONFIG.isUserLoggedIn()) {
                this.edt_kundennummer.setText(this.CONFIG.getLICFILE().getKundennummer());
                this.edt_firma.setText(this.CONFIG.getLICFILE().getFirma());
                this.edt_name.setText(this.CONFIG.getLICFILE().getName());
                this.edt_vorname.setText(this.CONFIG.getLICFILE().getVorname());
                this.edt_email.setText(this.CONFIG.getLICFILE().getBenutzername());
            }
            this.btn_senden = new JButton();
            this.getContentPane().add(this.btn_senden);
            this.btn_senden.setText("Daten jetzt senden");
            this.btn_senden.setBounds(12, 191, 140, 21);
            this.btn_senden.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (KontaktDialog.this.edt_email.getText().equals("")) {
                        JOptionPane.showMessageDialog(KontaktDialog.this.owner, "Bitte geben Sie eine E-Mailadresse ein.");
                    } else {
                        WebService ws = new WebService(KontaktDialog.this.CONFIG);
                        String[] res = ws.addClient_Informations(KontaktDialog.this.statustext, KontaktDialog.this.edt_kundennummer.getText(), KontaktDialog.this.edt_firma.getText(), KontaktDialog.this.edt_name.getText(), KontaktDialog.this.edt_vorname.getText(), KontaktDialog.this.edt_email.getText());
                        if (res[0].equals("true")) {
                            JOptionPane.showMessageDialog(KontaktDialog.this.owner, "Die Daten wurden erfolgreich \u00fcbermittelt.");
                            KontaktDialog.this.dispose();
                        } else {
                            JOptionPane.showMessageDialog(KontaktDialog.this.owner, "Fehler bei der \u00dcbermittlung:\n" + res[1] + "\n" + res[2]);
                        }
                    }
                }
            });
            this.btn_abbrechen = new JButton();
            this.getContentPane().add(this.btn_abbrechen);
            this.btn_abbrechen.setText("Abbrechen");
            this.btn_abbrechen.setBounds(175, 191, 140, 21);
            this.btn_abbrechen.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    KontaktDialog.this.dispose();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

