/*
 * Decompiled with CFR 0.152.
 */
package res;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import res.DesEncrypter;
import sun.misc.BASE64Decoder;

public class NormFile {
    private String SRD_KEY;
    private String SRD_IV;
    private File NormDatei;
    private String ID;
    private String Orig_Dateiname;
    private String Orig_Dateipfad;
    private String Orig_Dokumentgroesse;
    private String UPDTIME;
    private String CRTIME;
    private String UPDUSER;
    private String Pruefsumme;
    private String Orig_Dokument_Crypted;
    private String Revision;
    private String Bezeichnung;
    private String Produktnummer;

    public NormFile(String datei) {
        if (System.getProperty("debug", "0").equals("1")) {
            System.out.println("NormFile.NormFile: " + datei);
        }
        this.NormDatei = new File(datei);
    }

    public boolean open(String Provider2, String srd_key, String srd_iv) throws ZipException, IOException, JDOMException, OutOfMemoryError {
        Document doc;
        this.SRD_KEY = srd_key;
        this.SRD_IV = srd_iv;
        SAXBuilder builder = new SAXBuilder();
        try {
            ZipFile srdFile = new ZipFile(this.NormDatei);
            Enumeration<? extends ZipEntry> entries = srdFile.entries();
            ZipEntry entry = entries.nextElement();
            InputStream is = srdFile.getInputStream(entry);
            doc = builder.build(is);
        }
        catch (Exception e) {
            ZipInputStream in = new ZipInputStream(new FileInputStream(this.NormDatei));
            in.getNextEntry();
            doc = builder.build((InputStream)in);
        }
        Element licfile = doc.getRootElement();
        Namespace ns = licfile.getNamespace();
        Element Dokument = licfile.getChild("Document", ns);
        this.ID = Dokument.getChildText("ID", ns);
        this.Orig_Dateiname = Dokument.getChildText("Orig_Dateiname", ns);
        this.Orig_Dateipfad = Dokument.getChildText("Orig_Dateipfad", ns);
        if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            this.Orig_Dateipfad = this.Orig_Dateipfad.replaceAll("\\\\", System.getProperty("file.separator"));
        }
        this.Orig_Dokumentgroesse = Dokument.getChildText("Orig_Dokumentgroesse", ns);
        this.UPDTIME = Dokument.getChildText("UPDTIME", ns);
        this.CRTIME = Dokument.getChildText("CRTIME", ns);
        this.UPDUSER = Dokument.getChildText("UPDUSER", ns);
        this.Pruefsumme = Dokument.getChildText("Pruefsumme", ns);
        Element Produkt2 = licfile.getChild("Produkt", ns);
        this.ID = Produkt2.getChildText("ID", ns);
        this.Produktnummer = Produkt2.getChildText("Produktnummer", ns);
        this.Revision = Produkt2.getChildText("Revision", ns);
        this.Bezeichnung = Produkt2.getChildText("Bezeichnung", ns);
        Element element = Dokument.getChild("Orig_Dokument_Crypted", ns);
        this.Orig_Dokument_Crypted = element.getTextNormalize();
        return this.checkPruefsumme(Provider2);
    }

    private boolean checkPruefsumme(String Provider2) {
        String psum = String.valueOf(this.ID.substring(0, 8)) + -14 + Provider2 + 1701;
        try {
            DesEncrypter decrypter = new DesEncrypter(this.SRD_KEY, this.SRD_IV);
            byte[] decoded = new BASE64Decoder().decodeBuffer(this.Orig_Dokument_Crypted);
            ByteArrayInputStream in = new ByteArrayInputStream(decoded);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            decrypter.decrypt(in, out);
            String md5 = NormFile.MD5(new ByteArrayInputStream(out.toByteArray()));
            psum = String.valueOf(psum) + md5;
            psum = decrypter.encrypt(psum);
            decoded = new BASE64Decoder().decodeBuffer(this.Pruefsumme);
            String pruefsumme = new String(decoded);
            return pruefsumme.equals(psum);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getFileName() {
        return this.Orig_Dateiname;
    }

    public String getOrig_Dokumentgroesse() {
        return this.Orig_Dokumentgroesse;
    }

    public String getID() {
        return this.ID;
    }

    public String getUPDUSER() {
        return this.UPDUSER;
    }

    public String getUPDTIME() {
        return this.UPDTIME;
    }

    public String getCRTIME() {
        return this.CRTIME;
    }

    public String getBezeichnung() {
        return this.Bezeichnung;
    }

    public String getProduktnummer() {
        return this.Produktnummer;
    }

    public InputStream getPDFFile(String text, String datname) throws IOException {
        byte[] decoded = new BASE64Decoder().decodeBuffer(this.Orig_Dokument_Crypted);
        ByteArrayInputStream in = new ByteArrayInputStream(decoded);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DesEncrypter encrypter = new DesEncrypter(this.SRD_KEY, this.SRD_IV);
        encrypter.decrypt(in, out);
        ByteArrayOutputStream outpdf = new ByteArrayOutputStream();
        try {
            PdfReader reader = new PdfReader(new ByteArrayInputStream(out.toByteArray()));
            int n = reader.getNumberOfPages();
            PdfStamper stamp = new PdfStamper(reader, outpdf);
            int i = 0;
            BaseFont bf = BaseFont.createFont("Courier", "Cp1252", true);
            while (i < n) {
                PdfContentByte canvas = stamp.getOverContent(++i);
                canvas.beginText();
                canvas.setColorFill(new Color(166, 166, 166));
                Rectangle pageSize = reader.getPageSizeWithRotation(i);
                canvas.setFontAndSize(bf, 9.0f);
                if (reader.getPageRotation(i) == 90 || pageSize.width() > pageSize.height()) {
                    canvas.showTextAligned(0, text, 20.0f, 20.0f, 0.0f);
                } else {
                    canvas.showTextAligned(0, text, pageSize.width() - 20.0f - (pageSize.width() - 595.0f), 20.0f + (pageSize.height() - 842.0f), 90.0f);
                }
                canvas.endText();
            }
            stamp.close();
            out.close();
            outpdf.close();
            return new ByteArrayInputStream(outpdf.toByteArray());
        }
        catch (Exception de) {
            System.out.println("error");
            de.printStackTrace();
            return null;
        }
    }

    public String saveTo(String pfad) throws IOException {
        if (System.getProperty("debug", "0").equals("1")) {
            System.out.println("NormFile.saveTo: " + pfad + this.Orig_Dateipfad + this.Orig_Dateiname);
        }
        File f = new File(String.valueOf(pfad) + this.Orig_Dateipfad);
        f.mkdirs();
        f = new File(String.valueOf(pfad) + this.Orig_Dateipfad + this.Orig_Dateiname);
        f.createNewFile();
        FileInputStream fis = new FileInputStream(this.NormDatei);
        FileOutputStream fos = new FileOutputStream(f);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
        return String.valueOf(this.Orig_Dateipfad) + this.Orig_Dateiname;
    }

    public void saveAs(String dateiname) throws IOException {
        byte[] decoded = new BASE64Decoder().decodeBuffer(this.Orig_Dokument_Crypted);
        ByteArrayInputStream in = new ByteArrayInputStream(decoded);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DesEncrypter encrypter = new DesEncrypter(this.SRD_KEY, this.SRD_IV);
        encrypter.decrypt(in, out);
        File f = new File(dateiname);
        f.createNewFile();
        ByteArrayInputStream fis = new ByteArrayInputStream(out.toByteArray());
        FileOutputStream fos = new FileOutputStream(f);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    public boolean checkRevision(String revision) {
        if (System.getProperty("debug", "0").equals("1")) {
            System.out.println("NormFile.checkVersion: " + this.Orig_Dateiname + " " + this.Revision + " " + revision);
        }
        return Integer.parseInt(this.Revision) >= Integer.parseInt(revision);
    }

    public static String MD5(InputStream in) {
        try {
            String res = "";
            MessageDigest messagedigest = MessageDigest.getInstance("MD5");
            byte[] md = new byte[8192];
            int n = 0;
            while ((n = in.read(md)) > -1) {
                messagedigest.update(md, 0, n);
            }
            byte[] digest = messagedigest.digest();
            String s = "";
            int i = 0;
            while (i < digest.length) {
                s = Integer.toHexString(0xFF & digest[i]);
                res = s.length() < 2 ? String.valueOf(res) + "0" + s : String.valueOf(res) + s;
                ++i;
            }
            return res.toUpperCase();
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
        catch (IOException e) {
            return "";
        }
    }
}

