/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.image.BufferedImage;
import org.jpedal.PdfDecoder;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.PdfPageObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class ThumbnailDecoder {
    private PdfDecoder decode_pdf;
    private PdfStreamDecoder imageDecoder = null;
    private boolean stopDecoding = false;

    public ThumbnailDecoder(PdfDecoder decode_pdf) {
        this.decode_pdf = decode_pdf;
    }

    public void terminateDecoding() {
        this.stopDecoding = true;
        if (this.imageDecoder != null) {
            this.imageDecoder.terminateDecoding();
            while (this.imageDecoder != null && !this.imageDecoder.exitedDecoding()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public final synchronized BufferedImage getPageAsThumbnail(int pageNumber, int height) {
        this.stopDecoding = false;
        BufferedImage image = null;
        DynamicVectorRenderer imageDisplay = ObjectStore.getCachedPage((Integer)new Integer(pageNumber));
        if (imageDisplay != null) {
            imageDisplay.setObjectStoreRef(this.decode_pdf.objectStoreRef);
        } else {
            block11: {
                PdfPageObject pdfObject;
                int mediaH;
                int mediaW;
                int mediaY;
                int mediaX;
                block14: {
                    PdfObject Resources;
                    block13: {
                        block12: {
                            imageDisplay = new DynamicVectorRenderer(pageNumber, true, 1000, this.decode_pdf.objectStoreRef);
                            imageDisplay.setHiResImageForDisplayMode(this.decode_pdf.useHiResImageForDisplay);
                            if (pageNumber > this.decode_pdf.getPageCount()) {
                                LogWriter.writeLog((String)("Page " + pageNumber + " out of bounds"));
                                break block11;
                            }
                            mediaX = this.decode_pdf.pageData.getMediaBoxX(pageNumber);
                            mediaY = this.decode_pdf.pageData.getMediaBoxY(pageNumber);
                            mediaW = this.decode_pdf.pageData.getMediaBoxWidth(pageNumber);
                            mediaH = this.decode_pdf.pageData.getMediaBoxHeight(pageNumber);
                            String currentPageOffset = (String)this.decode_pdf.pagesReferences.get(new Integer(pageNumber));
                            if (currentPageOffset == null) break block11;
                            pdfObject = new PdfPageObject(currentPageOffset);
                            this.decode_pdf.currentPdfFile.readObject((PdfObject)pdfObject, currentPageOffset, false, null);
                            Resources = pdfObject.getDictionary(2004251818);
                            if (pdfObject == null) break block11;
                            this.imageDecoder = new PdfStreamDecoder(this.decode_pdf.useHiResImageForDisplay);
                            this.imageDecoder.setExternalImageRender(this.decode_pdf.customImageHandler);
                            if (!this.stopDecoding) break block12;
                            this.imageDecoder = null;
                            return null;
                        }
                        this.imageDecoder.setName(this.decode_pdf.filename);
                        this.imageDecoder.setStore(this.decode_pdf.objectStoreRef);
                        if (!this.stopDecoding) break block13;
                        this.imageDecoder = null;
                        return null;
                    }
                    this.imageDecoder.init(true, true, PdfDecoder.renderMode, 0, this.decode_pdf.pageData, pageNumber, imageDisplay, this.decode_pdf.currentPdfFile);
                    if (this.decode_pdf.globalResources != null) {
                        this.imageDecoder.readResources(this.decode_pdf.globalResources, true);
                    }
                    if (Resources != null) {
                        this.imageDecoder.readResources(Resources, true);
                    }
                    if (!this.stopDecoding) break block14;
                    this.imageDecoder = null;
                    return null;
                }
                try {
                    imageDisplay.init(mediaW, mediaH, this.decode_pdf.pageData.getRotation(pageNumber));
                    this.imageDecoder.decodePageContent((PdfObject)pdfObject, mediaX, mediaY, null, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.imageDecoder = null;
            ObjectStore.cachePage((Integer)new Integer(pageNumber), (DynamicVectorRenderer)imageDisplay);
        }
        if (!this.stopDecoding) {
            image = this.decode_pdf.getImageFromRenderer(height, imageDisplay, pageNumber);
        }
        return image;
    }
}

