/*
 * Decompiled with CFR 0.152.
 */
package gui.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import res.Config;

public class AboutBox
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JLabel logo = null;
    private JTextPane text = null;
    private JPanel pnl_bottom = null;
    private JButton btn_close = null;
    private Config CONFIG;

    public AboutBox(Config conf) {
        super(conf.getMasterFrame());
        this.CONFIG = conf;
        this.initialize();
    }

    private void initialize() {
        Point pos = this.getOwner().getLocationOnScreen();
        this.setBounds(new Rectangle(pos.x + 80, pos.y + 50, 500, 400));
        this.setResizable(false);
        this.setTitle(this.CONFIG.getText("AboutBox_Title"));
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.logo = new JLabel();
            this.logo.setIcon(new ImageIcon(this.getClass().getResource("/" + this.CONFIG.getProvider() + "/about.gif")));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.logo, "West");
            this.jContentPane.add((Component)this.getText(), "Center");
            this.jContentPane.add((Component)this.getPnl_bottom(), "South");
        }
        return this.jContentPane;
    }

    private JTextPane getText() {
        if (this.text == null) {
            this.text = new JTextPane();
            this.text.setText("\n\n" + this.CONFIG.getAPPNAME() + "\n" + "Version: " + this.CONFIG.getVERSION() + "\n" + "\n" + this.CONFIG.getCOPYBY() + this.CONFIG.getDEVBY() + "\n" + "Device-ID: " + this.CONFIG.getPID().substring(0, 8) + "\n" + "\n" + "OS-Name: " + System.getProperty("os.name") + "\n" + "Java-Version: " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")\n" + "Encoding: " + System.getProperty("file.encoding") + "\n" + "Apppath: " + System.getProperty("user.dir") + "\n" + "Userpath: " + this.CONFIG.getUserDataDir() + "\n" + "Classpath: " + System.getProperty("java.class.path") + "\n");
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            List<String> aList = bean.getInputArguments();
            int i = 0;
            while (i < aList.size()) {
                if (aList.get(i).toString().startsWith("-Xmx")) {
                    this.text.setText(String.valueOf(this.text.getText()) + "Memory: " + aList.get(i).toString().substring(4));
                }
                ++i;
            }
            this.text.setEditable(false);
        }
        return this.text;
    }

    private JPanel getPnl_bottom() {
        if (this.pnl_bottom == null) {
            this.pnl_bottom = new JPanel();
            this.pnl_bottom.setLayout(null);
            this.pnl_bottom.setPreferredSize(new Dimension(0, 40));
            this.pnl_bottom.add((Component)this.getBtn_close(), null);
        }
        return this.pnl_bottom;
    }

    private JButton getBtn_close() {
        if (this.btn_close == null) {
            this.btn_close = new JButton();
            this.btn_close.setPreferredSize(new Dimension(100, 25));
            this.btn_close.setSize(new Dimension(100, 25));
            this.btn_close.setLocation(new Point(382, 8));
            this.btn_close.setText("OK");
            this.btn_close.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AboutBox.this.dispose();
                }
            });
        }
        return this.btn_close;
    }
}

