/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.util.ImageUtil;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;

final class MlibThresholdOpImage
extends PointOpImage {
    private double[] low;
    private int[] lowInt;
    private double[] high;
    private int[] highInt;
    private double[] constants;
    private int[] constantsInt;

    public MlibThresholdOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, double[] dArray, double[] dArray2, double[] dArray3) {
        super(renderedImage, imageLayout, map, true);
        int n = this.getSampleModel().getNumBands();
        this.low = new double[n];
        this.lowInt = new int[n];
        this.high = new double[n];
        this.highInt = new int[n];
        this.constants = new double[n];
        this.constantsInt = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.low[n2] = dArray.length < n ? dArray[0] : dArray[n2];
            this.lowInt[n2] = ImageUtil.clampInt((int)Math.ceil(this.low[n2]));
            this.high[n2] = dArray2.length < n ? dArray2[0] : dArray2[n2];
            this.highInt[n2] = ImageUtil.clampInt((int)Math.floor(this.high[n2]));
            this.constants[n2] = dArray3.length < n ? dArray3[0] : dArray3[n2];
            this.constantsInt[n2] = ImageUtil.clampRoundInt(this.constants[n2]);
            ++n2;
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(rasterArray[0], rectangle, n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        switch (mediaLibAccessor2.getDataType()) {
            case 0: 
            case 2: 
            case 3: {
                int n2 = 0;
                while (n2 < mediaLibImageArray2.length) {
                    int[] nArray = mediaLibAccessor2.getIntParameters(n2, this.lowInt);
                    int[] nArray2 = mediaLibAccessor2.getIntParameters(n2, this.highInt);
                    int[] nArray3 = mediaLibAccessor2.getIntParameters(n2, this.constantsInt);
                    Image.Thresh5((mediaLibImage)mediaLibImageArray2[n2], (mediaLibImage)mediaLibImageArray[n2], (int[])nArray2, (int[])nArray, (int[])nArray3);
                    ++n2;
                }
                break;
            }
            case 4: 
            case 5: {
                int n3 = 0;
                while (n3 < mediaLibImageArray2.length) {
                    double[] dArray = mediaLibAccessor2.getDoubleParameters(n3, this.low);
                    double[] dArray2 = mediaLibAccessor2.getDoubleParameters(n3, this.high);
                    double[] dArray3 = mediaLibAccessor2.getDoubleParameters(n3, this.constants);
                    Image.Thresh5_Fp((mediaLibImage)mediaLibImageArray2[n3], (mediaLibImage)mediaLibImageArray[n3], (double[])dArray2, (double[])dArray, (double[])dArray3);
                    ++n3;
                }
                break;
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

