/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.pdf.BaseFont;
import java.io.IOException;

public class PdfBarcode
extends Chunk {
    public static final int CODE39 = 1;
    public static final int UPCA = 2;
    public static final int EAN13 = 3;
    public static final int INTERLEAVED_2_OF_5 = 4;
    public static final int[][] variableParity = new int[][]{{0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2}, {0, 0, 1, 0, 1, 1, 2, 2, 2, 2, 2, 2}, {0, 0, 1, 1, 0, 1, 2, 2, 2, 2, 2, 2}, {0, 0, 1, 1, 1, 0, 2, 2, 2, 2, 2, 2}, {0, 1, 0, 0, 1, 1, 2, 2, 2, 2, 2, 2}, {0, 1, 1, 0, 0, 1, 2, 2, 2, 2, 2, 2}, {0, 1, 1, 1, 0, 0, 2, 2, 2, 2, 2, 2}, {0, 1, 0, 1, 0, 1, 2, 2, 2, 2, 2, 2}, {0, 1, 0, 1, 1, 0, 2, 2, 2, 2, 2, 2}, {0, 1, 1, 0, 1, 0, 2, 2, 2, 2, 2, 2}};

    public PdfBarcode(String string, int n, int n2, String string2) throws BadElementException, DocumentException, IOException {
        super(PdfBarcode.convertToCode(n, string2), new Font(BaseFont.createFont(string, "winansi", true), (float)n2));
    }

    public PdfBarcode(String string, int n, int n2, long l) throws BadElementException, DocumentException, IOException {
        super(PdfBarcode.convertToCode(n, String.valueOf(l)), new Font(BaseFont.createFont(string, "winansi", true), (float)n2));
    }

    private static String convertToCode(int n, String string) throws BadElementException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        int n3 = 0;
        try {
            switch (n) {
                case 1: {
                    stringBuffer.append('*');
                    while (n3 < n2) {
                        stringBuffer.append(string.substring(n3++, n3));
                    }
                    stringBuffer.append('*');
                    break;
                }
                case 2: {
                    if (n2 > 12) {
                        throw new BadElementException("An UPC-A barcode can only encode a 12 digit number (your number was " + string + ").");
                    }
                    string = PdfBarcode.addZero(string, 12);
                    int n4 = Integer.parseInt(string.substring(n3++, n3));
                    stringBuffer.append((char)(n4 + 80));
                    while (n3 < 6) {
                        n4 = Integer.parseInt(string.substring(n3++, n3));
                        stringBuffer.append((char)(n4 + 48));
                    }
                    stringBuffer.append('p');
                    while (n3 < 11) {
                        n4 = Integer.parseInt(string.substring(n3++, n3));
                        stringBuffer.append((char)(n4 + 64));
                    }
                    n4 = Integer.parseInt(string.substring(11));
                    stringBuffer.append((char)(n4 + 96));
                    break;
                }
                case 3: {
                    if (n2 > 13) {
                        throw new BadElementException("An EAN-13 barcode can only encode a 13 digit number (your number was " + string + ").");
                    }
                    string = PdfBarcode.addZero(string, 13);
                    int n5 = Integer.parseInt(string.substring(n3++, n3));
                    stringBuffer.append((char)(n5 + 33));
                    int n6 = Integer.parseInt(string.substring(n3++, n3));
                    stringBuffer.append((char)(n6 + 96));
                    while (n3 < 7) {
                        n6 = Integer.parseInt(string.substring(n3++, n3));
                        stringBuffer.append((char)(n6 + 48 + 16 * variableParity[n5][n3 - 2]));
                    }
                    stringBuffer.append('|');
                    while (n3 < 12) {
                        n6 = Integer.parseInt(string.substring(n3++, n3));
                        stringBuffer.append((char)(n6 + 48 + 16 * variableParity[n5][n3 - 2]));
                    }
                    n6 = Integer.parseInt(string.substring(12));
                    stringBuffer.append((char)(n6 + 112));
                    break;
                }
                case 4: {
                    int n7;
                    if (n2 % 2 == 1) {
                        string = PdfBarcode.addZero(string, n2 + 1);
                    }
                    stringBuffer.append('(');
                    while (string.length() > 2) {
                        n7 = Integer.parseInt(string.substring(0, 2));
                        stringBuffer.append(PdfBarcode.convertInterleaved(n7));
                        n3 += 2;
                        string = string.substring(2);
                    }
                    n7 = Integer.parseInt(string);
                    stringBuffer.append(PdfBarcode.convertInterleaved(n7));
                    stringBuffer.append(')');
                    break;
                }
                default: {
                    throw new BadElementException("This type of barcode is not supported yet: " + n);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadElementException("NumberFormatException at position " + n3 + " in " + string + ": " + numberFormatException.getMessage());
        }
        return stringBuffer.toString();
    }

    private static char convertInterleaved(int n) throws NumberFormatException {
        int n2;
        if (n < 50) {
            n2 = 48;
        } else if (n < 100) {
            n2 = 142;
        } else {
            throw new NumberFormatException(String.valueOf(n));
        }
        return (char)(n + n2);
    }

    private static String addZero(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

