/*
 * Decompiled with CFR 0.152.
 */
package res;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import res.Config;
import res.DesEncrypter;
import res.Lizenz_Client;
import res.Lizenz_Vertrag;
import res.Produkt;
import res.obj.redMenu;
import res.obj.redPrinter_Blacklist;
import sun.misc.BASE64Decoder;

public class LicFile {
    private Vector Normen = new Vector();
    private Vector Clients = new Vector();
    private Vector Vertraege = new Vector();
    public String Filename = "";
    private String ID = "";
    private String Benutzer = "";
    private String Kundennummer = "";
    private String Firma = "";
    private String Name = "";
    private String Vorname = "";
    private String Benutzername = "";
    private String Passwort = "";
    private String SRD_KEY = "";
    private String SRD_IV = "";
    private String Provider = "";
    private String Info = "";
    private String Lizenz_Vertrag = "";
    private String UMeldung = "";
    private String UZwingend = "";
    private String Inhalt = "";
    private String mypsum = "";
    private String psum = "";
    private String Switch_Name = "";
    private String Muster_Produkt_Bezeichnung = "";
    private boolean canEdit = false;
    private boolean checkDevice_ID_at_StartUp = false;
    private boolean NoMACAdrCheck = false;
    private Config CONFIG;
    private Object[] Links;
    private Object[] Printer_Blacklist;

    public LicFile(String filename, Config conf) {
        this.CONFIG = conf;
        if (this.CONFIG.isDebug()) {
            System.out.println("LicFile.LicFile: " + filename);
        }
        this.Filename = filename;
    }

    public boolean open() throws ZipException, IOException, JDOMException {
        InputStream mroFile = null;
        try {
            ZipFile srlFile = new ZipFile(this.Filename);
            ZipEntry entry = srlFile.entries().nextElement();
            mroFile = this.getMroFile(srlFile.getInputStream(entry));
            srlFile.close();
        }
        catch (Exception e) {
            ZipInputStream in = new ZipInputStream(new FileInputStream(this.Filename));
            in.getNextEntry();
            mroFile = this.getMroFile(in);
            in.close();
        }
        InputStream xmlFile = this.getXmlFile(mroFile);
        mroFile.close();
        if (this.CONFIG.DEVELOP) {
            byte zeichen;
            InputStream fis = xmlFile;
            FileOutputStream fos = new FileOutputStream(new File("licfile.xml"));
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
            fos.close();
            do {
                zeichen = (byte)xmlFile.read();
                this.Inhalt = String.valueOf(this.Inhalt) + (char)zeichen;
            } while (zeichen != -1);
            xmlFile.reset();
        }
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(xmlFile);
        Element licfile = doc.getRootElement();
        Namespace ns = licfile.getNamespace();
        Element benutzer = licfile.getChild("Benutzer", ns);
        Element info = licfile.getChild("Info", ns);
        Element konfiguration = licfile.getChild("Konfiguration", ns);
        this.UMeldung = konfiguration.getChildText("Aktualisierung_Lizenzdatei_Medlung_Datum", ns);
        this.UZwingend = konfiguration.getChildText("Aktualisierung_Lizenzdatei_Zwingend_Datum", ns);
        this.Switch_Name = konfiguration.getChildText("Switch_Name", ns);
        try {
            this.Muster_Produkt_Bezeichnung = konfiguration.getChildText("Muster_Produkt_Bezeichnung", ns);
            if (this.Muster_Produkt_Bezeichnung == null) {
                this.Muster_Produkt_Bezeichnung = "#Produktnummer - #Bezeichnung";
            }
        }
        catch (Exception e) {
            this.Muster_Produkt_Bezeichnung = "#Produktnummer - #Bezeichnung";
        }
        this.Firma = benutzer.getChildText("Firma", ns);
        this.Name = benutzer.getChildText("Name", ns);
        this.Vorname = benutzer.getChildText("Vorname", ns);
        this.Info = String.valueOf(this.Info) + benutzer.getChildText("Firma", ns) + "\n";
        this.Info = String.valueOf(this.Info) + benutzer.getChildText("Name", ns) + " " + benutzer.getChildText("Vorname", ns) + "\n";
        this.Info = String.valueOf(this.Info) + benutzer.getChildText("Strasse", ns) + " " + benutzer.getChildText("Hausnummer", ns) + "\n";
        this.Info = String.valueOf(this.Info) + benutzer.getChildText("PLZ", ns) + " " + benutzer.getChildText("Ort", ns) + "\n";
        this.Info = String.valueOf(this.Info) + benutzer.getChildText("Kundennummer", ns) + "\n";
        this.Info = String.valueOf(this.Info) + benutzer.getChildText("Benutzername", ns) + "\n";
        this.Info = String.valueOf(this.Info) + "ID: " + benutzer.getChildText("ID", ns) + "\n";
        this.Benutzer = benutzer.getChildText("Firma", ns) != "" ? String.valueOf(benutzer.getChildText("Firma", ns)) + " " + benutzer.getChildText("Name", ns) + " " + benutzer.getChildText("Vorname", ns) : String.valueOf(benutzer.getChildText("Name", ns)) + " " + benutzer.getChildText("Vorname", ns);
        this.Benutzer = this.Benutzer.replaceAll("\n", " ");
        this.ID = benutzer.getChildText("ID", ns);
        this.Kundennummer = benutzer.getChildText("Kundennummer", ns);
        this.Benutzername = benutzer.getChildText("Benutzername", ns);
        this.Passwort = benutzer.getChildText("Passwort", ns);
        try {
            this.canEdit = !benutzer.getChildText("canEdit", ns).equals("0");
        }
        catch (Exception e) {
            this.canEdit = false;
        }
        try {
            this.checkDevice_ID_at_StartUp = benutzer.getChildText("checkDevice_ID_at_StartUp", ns).equals("1");
        }
        catch (Exception e) {
            this.checkDevice_ID_at_StartUp = true;
        }
        try {
            this.NoMACAdrCheck = benutzer.getChildText("NoMACAdrCheck", ns).equals("1");
        }
        catch (Exception e) {
            this.NoMACAdrCheck = false;
        }
        this.Provider = info.getChildText("Provider", ns);
        this.SRD_KEY = konfiguration.getChildText("SRD_KEY", ns);
        DesEncrypter decrypter = new DesEncrypter(this.CONFIG.getKEY(), this.CONFIG.getIV());
        byte[] decoded = new BASE64Decoder().decodeBuffer(this.SRD_KEY);
        this.SRD_KEY = decrypter.decrypt(decoded);
        this.SRD_IV = konfiguration.getChildText("SRD_IV", ns);
        DesEncrypter decrypter2 = new DesEncrypter(this.CONFIG.getKEY(), this.CONFIG.getIV());
        byte[] decoded2 = new BASE64Decoder().decodeBuffer(this.SRD_IV);
        this.SRD_IV = decrypter2.decrypt(decoded2);
        List produktliste = licfile.getChildren("Produkt", ns);
        Iterator produkte = produktliste.iterator();
        int prodcnt = 0;
        while (produkte.hasNext()) {
            Element produkt = (Element)produkte.next();
            boolean exists = false;
            Produkt aktnorm = new Produkt(produkt, ns, this.Muster_Produkt_Bezeichnung);
            if (!exists) {
                this.Normen.add(aktnorm);
            }
            ++prodcnt;
        }
        List clientliste = licfile.getChildren("Lizenz_Client", ns);
        Iterator clients = clientliste.iterator();
        int clientcnt = 0;
        while (clients.hasNext()) {
            Element client = (Element)clients.next();
            this.Clients.add(new Lizenz_Client(client, ns));
            ++clientcnt;
        }
        List lizenzvertragliste = licfile.getChildren("Lizenz_Vertrag", ns);
        Iterator lizenzvertraege = lizenzvertragliste.iterator();
        while (lizenzvertraege.hasNext()) {
            Element lizenzvertrag = (Element)lizenzvertraege.next();
            this.Vertraege.add(new Lizenz_Vertrag(lizenzvertrag, ns));
        }
        List menulist = licfile.getChildren("Menu", ns);
        Iterator menu = menulist.iterator();
        this.Links = new Object[menulist.size()];
        int i = 0;
        while (menu.hasNext()) {
            redMenu m = new redMenu((Element)menu.next(), ns);
            this.Links[i] = m;
            ++i;
        }
        List blacklist = licfile.getChildren("Printer_Blacklist", ns);
        Iterator printer = blacklist.iterator();
        this.Printer_Blacklist = new Object[blacklist.size()];
        i = 0;
        while (printer.hasNext()) {
            redPrinter_Blacklist p = new redPrinter_Blacklist((Element)printer.next(), ns);
            this.Printer_Blacklist[i] = p;
            ++i;
        }
        this.psum = info.getChildText("Pruefsumme", ns);
        this.mypsum = String.valueOf(benutzer.getChildText("ID", ns).substring(0, 8)) + (-17 + clientcnt) + info.getChildText("URL", ns).substring(8, 13) + (1500 + prodcnt);
        xmlFile.close();
        return this.mypsum.equals(this.psum);
    }

    public boolean checkClient(String pid) {
        int c = 0;
        while (c < this.Clients.size()) {
            Lizenz_Client lc = (Lizenz_Client)this.Clients.get(c);
            if (pid.equals(lc.getGeraete_ID())) {
                return true;
            }
            ++c;
        }
        return false;
    }

    public String getInfo() {
        return this.Info;
    }

    public String getInhalt() {
        return this.Inhalt;
    }

    public Vector getClients() {
        return this.Clients;
    }

    public Vector getVertraege() {
        return this.Vertraege;
    }

    public String getNormFileText() {
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        return String.valueOf(this.Benutzer) + " | " + df.format(new Date());
    }

    public String getBenutzer() {
        return this.Benutzer;
    }

    public String getBenutzername() {
        return this.Benutzername;
    }

    public String getKundennummer() {
        if (this.Kundennummer.equals("")) {
            return this.Benutzername;
        }
        return this.Kundennummer;
    }

    public String getPasswort() {
        return this.Passwort;
    }

    public String[] getGruppen(String sprache) {
        Vector<String> Gruppen = new Vector<String>();
        int c = 0;
        while (c < this.Normen.size()) {
            Produkt norm = (Produkt)this.Normen.get(c);
            if (norm.getGruppe_Sprach_Code().equals(sprache) && Gruppen.indexOf(norm.Gruppe) == -1 && !norm.Gruppe.equals("")) {
                Gruppen.add(norm.Gruppe);
            }
            ++c;
        }
        String[] tmp = new String[Gruppen.size()];
        Gruppen.toArray(tmp);
        return tmp;
    }

    public String[] getUnterGruppen(String Gruppe) {
        Vector<String> UnterGruppen = new Vector<String>();
        int c = 0;
        while (c < this.Normen.size()) {
            Produkt norm = (Produkt)this.Normen.get(c);
            if (Gruppe.equals(norm.Gruppe) && UnterGruppen.indexOf(norm.Untergruppe) == -1 && !norm.Untergruppe.equals("")) {
                UnterGruppen.add(norm.Untergruppe);
            }
            ++c;
        }
        String[] tmp = new String[UnterGruppen.size()];
        UnterGruppen.toArray(tmp);
        return tmp;
    }

    public Vector getNormen() {
        return this.Normen;
    }

    public String getSRD_KEY() {
        return this.SRD_KEY;
    }

    public String getSRD_IV() {
        return this.SRD_IV;
    }

    public String getProvider() {
        return this.Provider;
    }

    public String getSwitch_Name() {
        return this.Switch_Name;
    }

    public String getLizenz_Vertrag() {
        return this.Lizenz_Vertrag;
    }

    public String getpsum() {
        return this.psum;
    }

    public String getmypsum() {
        return this.mypsum;
    }

    public boolean showUMeldung() {
        Date now = new Date();
        Date d = new Date();
        try {
            d = new SimpleDateFormat("yyyy-MM-dd").parse(this.UMeldung.substring(0, 10));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return now.after(d);
    }

    public boolean showUZwingend() {
        Date now = new Date();
        Date d = new Date();
        try {
            d = new SimpleDateFormat("yyyy-MM-dd").parse(this.UZwingend.substring(0, 10));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return now.after(d);
    }

    private InputStream getMroFile(InputStream srlFile) throws IOException {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = srlFile.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        srlFile.close();
        out.close();
        return new ByteArrayInputStream(out.toByteArray());
    }

    private InputStream getXmlFile(InputStream mroFile) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            DesEncrypter encrypter = new DesEncrypter(this.CONFIG.getKEY(), this.CONFIG.getIV());
            encrypter.decrypt(mroFile, out);
        }
        catch (Exception ef) {
            System.err.println("decrypt");
            ef.printStackTrace();
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    public void saveTo(String newFile) throws IOException {
        File f;
        if (this.CONFIG.isDebug()) {
            System.out.println("LicFile.saveTo: " + newFile);
        }
        if (!(f = new File(newFile)).exists()) {
            f.createNewFile();
        }
        FileInputStream fis = new FileInputStream(new File(this.Filename));
        FileOutputStream fos = new FileOutputStream(f);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    public boolean checkBenutzer(String benutzer, String passwort) {
        if (System.getProperty("superdebug", "0").equals("1")) {
            System.out.println("licfile.checkBenutzer:");
            System.out.println(String.valueOf(benutzer) + " " + this.Benutzername);
            System.out.println(String.valueOf(benutzer) + " " + this.Kundennummer);
            System.out.println(String.valueOf(passwort.length()) + " " + this.Passwort);
        }
        return (this.Benutzername.equals(benutzer) || this.Kundennummer.equals(benutzer)) && this.Passwort.equals(passwort);
    }

    public String getID() {
        return this.ID;
    }

    public Object[] getLinks() {
        return this.Links;
    }

    public Object[] getPrinter_Blacklist() {
        if (this.CONFIG.DEVELOP) {
            return new Object[0];
        }
        return this.Printer_Blacklist;
    }

    public boolean canEdit() {
        return this.canEdit;
    }

    public boolean checkDevice_ID_at_StartUp() {
        return this.checkDevice_ID_at_StartUp;
    }

    public boolean isNoMACAdrCheck() {
        return this.NoMACAdrCheck;
    }

    public int getKulanz() {
        return 30;
    }

    public String getFirma() {
        return this.Firma;
    }

    public String getName() {
        return this.Name;
    }

    public String getVorname() {
        return this.Vorname;
    }
}

