/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriter;
import java.awt.image.SampleModel;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;

public class J2KImageWriterSpi
extends ImageWriterSpi {
    private static String[] readerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderSpi"};
    private static String[] formatNames = new String[]{"jpeg 2000", "JPEG 2000", "jpeg2000", "JPEG2000"};
    private static String[] extensions = new String[]{"jp2"};
    private static String[] mimeTypes = new String[]{"image/jp2", "image/jpeg2000"};
    private boolean registered = false;

    public J2KImageWriterSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), formatNames, extensions, mimeTypes, "com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriter", STANDARD_OUTPUT_TYPE, readerSpiNames, false, null, null, null, null, true, "com_sun_media_imageio_plugins_jpeg2000_image_1.0", "com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadataFormat", null, null);
    }

    public String getDescription(Locale locale) {
        String string = PackageUtil.getSpecificationTitle() + " JPEG 2000 Image Writer";
        return string;
    }

    public void onRegistration(ServiceRegistry serviceRegistry, Class clazz) {
        Object obj;
        if (this.registered) {
            return;
        }
        this.registered = true;
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName("com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriterCodecLibSpi");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (clazz2 != null && (obj = serviceRegistry.getServiceProviderByClass(clazz2)) != null) {
            serviceRegistry.setOrdering(clazz, obj, this);
        }
    }

    public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
        if (sampleModel.getNumBands() > 16384) {
            return false;
        }
        return sampleModel.getDataType() >= 0 && sampleModel.getDataType() <= 3;
    }

    public ImageWriter createWriterInstance(Object object) throws IIOException {
        return new J2KImageWriter(this);
    }
}

