/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openssl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.openssl.PasswordFinder;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class PEMReader
extends BufferedReader {
    private PasswordFinder pFinder;
    private String provider;

    public PEMReader(Reader reader) {
        super(reader);
    }

    public PEMReader(Reader reader, PasswordFinder passwordFinder) {
        this(reader, passwordFinder, "BC");
    }

    public PEMReader(Reader reader, PasswordFinder passwordFinder, String string) {
        super(reader);
        this.pFinder = passwordFinder;
        this.provider = string;
    }

    public Object readObject() throws IOException {
        String string;
        while ((string = this.readLine()) != null) {
            if (string.indexOf("-----BEGIN CERTIFICATE") != -1) {
                return this.readCertificate("-----END CERTIFICATE");
            }
            if (string.indexOf("-----BEGIN X509 CERTIFICATE") != -1) {
                return this.readCertificate("-----END X509 CERTIFICATE");
            }
            if (string.indexOf("-----BEGIN RSA PRIVATE KEY") != -1) {
                try {
                    return this.readKeyPair("RSA", "-----END RSA PRIVATE KEY");
                }
                catch (Exception exception) {
                    throw new IOException("problem creating RSA private key: " + exception.toString());
                }
            }
            if (string.indexOf("-----BEGIN DSA PRIVATE KEY") == -1) continue;
            try {
                return this.readKeyPair("DSA", "-----END DSA PRIVATE KEY");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IOException("problem creating RSA private key: " + exception.toString());
            }
        }
        return null;
    }

    private X509Certificate readCertificate(String string) throws IOException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = this.readLine()) != null) {
            if (string2.indexOf(string) != -1) break;
            stringBuffer.append(string2.trim());
        }
        if (string2 == null) {
            throw new IOException(string + " not found");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.decode(stringBuffer.toString()));
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", this.provider);
            return (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        }
        catch (Exception exception) {
            throw new IOException("problem parsing cert: " + exception.toString());
        }
    }

    private SecretKey getKey(String string, int n, byte[] byArray) throws IOException {
        MessageDigest messageDigest;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = n;
        if (this.pFinder == null) {
            throw new IOException("No password finder specified, but a password is required");
        }
        char[] cArray = this.pFinder.getPassword();
        if (cArray == null) {
            throw new IOException("Password is null, but a password is required");
        }
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new IOException("can't create digest: " + exception.toString());
        }
        while (true) {
            int n4 = 0;
            while (n4 != cArray.length) {
                messageDigest.update((byte)cArray[n4]);
                ++n4;
            }
            messageDigest.update(byArray);
            byte[] byArray3 = messageDigest.digest();
            int n5 = n3 > byArray3.length ? byArray3.length : n3;
            System.arraycopy(byArray3, 0, byArray2, n2, n5);
            n3 = byArray2.length - (n2 += n5);
            if (n3 == 0) break;
            messageDigest.reset();
            messageDigest.update(byArray3);
        }
        return new SecretKeySpec(byArray2, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private KeyPair readKeyPair(String string, String string2) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string3 = this.readLine()) != null) {
            if (string3.startsWith("Proc-Type: 4,ENCRYPTED")) {
                bl = true;
                continue;
            }
            if (string3.startsWith("DEK-Info:")) {
                string4 = string3.substring(10);
                continue;
            }
            if (string3.indexOf(string2) != -1) break;
            stringBuffer.append(string3.trim());
        }
        byte[] byArray = null;
        if (bl) {
            object6 = new StringTokenizer(string4, ",");
            object5 = ((StringTokenizer)object6).nextToken();
            if (((String)object5).equals("DES-EDE3-CBC")) {
                object4 = "DESede";
                object3 = Hex.decode(((StringTokenizer)object6).nextToken());
                object2 = this.getKey((String)object4, 24, (byte[])object3);
                object = Cipher.getInstance("DESede/CBC/PKCS5Padding", this.provider);
                ((Cipher)object).init(2, (Key)object2, new IvParameterSpec((byte[])object3));
                byArray = ((Cipher)object).doFinal(Base64.decode(stringBuffer.toString()));
            } else {
                if (!((String)object5).equals("DES-CBC")) throw new IOException("unknown encryption with private key");
                object4 = "DES";
                object3 = Hex.decode(((StringTokenizer)object6).nextToken());
                object2 = this.getKey((String)object4, 8, (byte[])object3);
                object = Cipher.getInstance("DES/CBC/PKCS5Padding", this.provider);
                ((Cipher)object).init(2, (Key)object2, new IvParameterSpec((byte[])object3));
                byArray = ((Cipher)object).doFinal(Base64.decode(stringBuffer.toString()));
            }
        } else {
            byArray = Base64.decode(stringBuffer.toString());
        }
        object4 = new ByteArrayInputStream(byArray);
        object3 = new DERInputStream((InputStream)object4);
        object2 = (ASN1Sequence)((DERInputStream)object3).readObject();
        if (string.equals("RSA")) {
            object = (DERInteger)((ASN1Sequence)object2).getObjectAt(0);
            DERInteger dERInteger = (DERInteger)((ASN1Sequence)object2).getObjectAt(1);
            DERInteger dERInteger2 = (DERInteger)((ASN1Sequence)object2).getObjectAt(2);
            DERInteger dERInteger3 = (DERInteger)((ASN1Sequence)object2).getObjectAt(3);
            DERInteger dERInteger4 = (DERInteger)((ASN1Sequence)object2).getObjectAt(4);
            DERInteger dERInteger5 = (DERInteger)((ASN1Sequence)object2).getObjectAt(5);
            DERInteger dERInteger6 = (DERInteger)((ASN1Sequence)object2).getObjectAt(6);
            DERInteger dERInteger7 = (DERInteger)((ASN1Sequence)object2).getObjectAt(7);
            DERInteger dERInteger8 = (DERInteger)((ASN1Sequence)object2).getObjectAt(8);
            object6 = new RSAPublicKeySpec(dERInteger.getValue(), dERInteger2.getValue());
            object5 = new RSAPrivateCrtKeySpec(dERInteger.getValue(), dERInteger2.getValue(), dERInteger3.getValue(), dERInteger4.getValue(), dERInteger5.getValue(), dERInteger6.getValue(), dERInteger7.getValue(), dERInteger8.getValue());
        } else {
            object = (DERInteger)((ASN1Sequence)object2).getObjectAt(0);
            DERInteger dERInteger = (DERInteger)((ASN1Sequence)object2).getObjectAt(1);
            DERInteger dERInteger9 = (DERInteger)((ASN1Sequence)object2).getObjectAt(2);
            DERInteger dERInteger10 = (DERInteger)((ASN1Sequence)object2).getObjectAt(3);
            DERInteger dERInteger11 = (DERInteger)((ASN1Sequence)object2).getObjectAt(4);
            DERInteger dERInteger12 = (DERInteger)((ASN1Sequence)object2).getObjectAt(5);
            object5 = new DSAPrivateKeySpec(dERInteger12.getValue(), dERInteger.getValue(), dERInteger9.getValue(), dERInteger10.getValue());
            object6 = new DSAPublicKeySpec(dERInteger11.getValue(), dERInteger.getValue(), dERInteger9.getValue(), dERInteger10.getValue());
        }
        object = KeyFactory.getInstance(string, this.provider);
        return new KeyPair(((KeyFactory)object).generatePublic((KeySpec)object6), ((KeyFactory)object).generatePrivate((KeySpec)object5));
    }
}

